## Create (Action)

Creates a (drillthrough) action.




### Description

Drillthrough actions only are supported for the time being. They are used in Excel under the
`Additional Actions` menu in the pivot tables.

<pre>
CREATE DRILLTHROUGH ACTION [name]
    AS [ MAXROWS value ] RETURN return-expression [ AS "column-name" ], ...
        , [ TARGET = [cube].[measure-group] ]
</pre>

The RETURN expressions are similar to the ones used in the DRILLTHROUGH statement.

The MAXROWS is optional; when not specified the value as defined by the `icCube.xml` property
`icCube.drillthroughDefaultMaxRows` is used.

The TARGET is optional; when not specified the action is targeting all the measure groups. Use the cube
name when the schema contains several cubes.

Example :

<pre>
CREATE DRILLTHROUGH ACTION [Sales Details]
    AS RETURN [Measures].[Amount], [Article], [Geography]
    , TARGET = [Sales]
</pre>

is defining a drillthrough action targeting the measures of the `Sales` measure group.



                                                                      

### See Also


[Drop (Action)](Drop%20(Action).md)

[Drillthrough](Drillthrough.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
